'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Button_NeuerPreis_Click()
On Error GoTo Err_Button_NeuerPreis_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
          
    'Eigenen Formularnamen merken fr Aktualisierung
    FormularName = "Einstellungen_2"
    FormularBereich = "Steuersaetze"
    
    'Eigentliches Formular ffnen
    stDocName = "Steuersatz_neu"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
        
Exit_Button_NeuerPreis_Click:
    Exit Sub

Err_Button_NeuerPreis_Click:
    MsgBox err.Description
    Resume Exit_Button_NeuerPreis_Click

End Sub

Private Sub Button_SteuersatzLoeschen_Click()
    On Error GoTo ERROR_Button_SteuersatzLoeschen_Click

    Dim dbs As Database
    Dim rst As Recordset
    Dim strFilter As String
    
    'Eigenen Formularnamen merken fr Aktualisierung
    FormularName = "Einstellungen_2"
    FormularBereich = "Steuersaetze"
    
    'Tabelle ffnen
    Set dbs = CurrentDb
    Set rst = Me.RecordsetClone
    
    'wenn Datensatz vorhanden, dann lschen...
    If (rst.RecordCount = 0) Then
        Set dbs = Nothing
        MsgBox "Keine Steuerstze vorhanden.", vbInformation, "Hinweis"
    Else
        strFilter = "SELECT * FROM Steuersaetze WHERE [lfd_Nr] = " & AktSteuersatz
        Set rst = dbs.OpenRecordset(strFilter)
        If MsgBox("Ausgewhlten Steuersatz [" & rst!Prozent & "% - " & rst!Bezeichnung & "] wirklich lschen?", vbYesNo + vbQuestion + vbDefaultButton2, "Steuersatz lschen...") = vbNo Then
            rst.Close
            Set dbs = Nothing
            Exit Sub
        End If
        rst.Delete
        rst.Requery
        rst.Close
        Set dbs = Nothing
        
        'Anzeige aktualisieren
        Me.Requery
    
    End If
    
EXIT_Button_SteuersatzLoeschen_Click:
    Exit Sub
    
ERROR_Button_SteuersatzLoeschen_Click:
    MsgBox err.Description
    Resume EXIT_Button_SteuersatzLoeschen_Click
    
End Sub

Private Sub Form_Current()
    AktSteuersatz = Me.lfd_Nr.Value
End Sub
